// GetWindowTitleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "GetWindowTitle.h"
#include "GetWindowTitleDlg.h"
#include "Winuser.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetWindowTitleDlg dialog

CGetWindowTitleDlg::CGetWindowTitleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGetWindowTitleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGetWindowTitleDlg)
	m_Title = _T("");
	m_ID = _T("");
	m_bd = _T("");
	m_bh = _T("");
	m_gd = _T("");
	m_gh = _T("");
	m_rd = _T("");
	m_rh = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CGetWindowTitleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetWindowTitleDlg)
	DDX_Control(pDX, IDC_PRE_VIEW, m_pre);
	DDX_Text(pDX, IDC_EDIT_TITLE, m_Title);
	DDX_Text(pDX, IDC_ID, m_ID);
	DDX_Text(pDX, IDC_bd, m_bd);
	DDX_Text(pDX, IDC_bh, m_bh);
	DDX_Text(pDX, IDC_gd, m_gd);
	DDX_Text(pDX, IDC_gh, m_gh);
	DDX_Text(pDX, IDC_rd, m_rd);
	DDX_Text(pDX, IDC_rh, m_rh);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGetWindowTitleDlg, CDialog)
	//{{AFX_MSG_MAP(CGetWindowTitleDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_SELECT, OnSelect)
	ON_WM_TIMER()
	ON_WM_ACTIVATE()
	ON_WM_ERASEBKGND()
	ON_BN_CLICKED(IDC_HIDE, OnHide)
	ON_BN_CLICKED(IDC_SHOW, OnShow)
	ON_BN_CLICKED(IDC_CHANGE_TASK_BAR, OnChangeTaskBar)
	ON_BN_CLICKED(IDC_BUTTON_Parent, OnBUTTONParent)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetWindowTitleDlg message handlers

BOOL CGetWindowTitleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	::SetWindowPos(GetSafeHwnd(),HWND_TOPMOST,0,0,0,0,
		SWP_NOSIZE|SWP_NOMOVE);	
	
	count=0;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CGetWindowTitleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CGetWindowTitleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CGetWindowTitleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CGetWindowTitleDlg::OnSelect() 
{
	// TODO: Add your control notification handler code here
	SetTimer(1,55,0);
}

void CGetWindowTitleDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	if (nIDEvent==1)
	{
		POINT cpt;
		::GetCursorPos(&cpt);
		hWnd=::WindowFromPoint(cpt);
		char title[256];
		::GetWindowText(hWnd,title,256);
		m_Title=title;
		int ID=(int)hWnd;
		itoa(ID,title,16);
		m_ID=title;
		m_ID.MakeUpper();

		//show rgb color
		HDC hDC=::GetDC(NULL);
		COLORREF color=::GetPixel(hDC,cpt.x,cpt.y);
		m_rh.Format("%0x",GetRValue(color));
		m_gh.Format("%0x",GetGValue(color));
		m_bh.Format("%0x",GetBValue(color));
		m_rh.MakeUpper();
		m_gh.MakeUpper();
		m_bh.MakeUpper();


		m_rd.Format("%d",GetRValue(color));
		m_gd.Format("%d",GetGValue(color));
		m_bd.Format("%d",GetBValue(color));
		m_rd.MakeUpper();
		m_gd.MakeUpper();
		m_bd.MakeUpper();

		::ReleaseDC(NULL,hDC);

//Pre view the color
		CDC *pDC=m_pre.GetDC();
		CBrush cb(color);
		RECT rect;
		m_pre.GetClientRect(&rect);
		pDC->FillRect(&rect,&cb);
		cb.DeleteObject();
		ReleaseDC(pDC);
		
		UpdateData(0);
	}

	CDialog::OnTimer(nIDEvent);
}

void CGetWindowTitleDlg::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CDialog::OnActivate(nState, pWndOther, bMinimized);
	
	// TODO: Add your message handler code here
	if(nState==WA_INACTIVE)
	{
		KillTimer(1);//£ 
	}

}

void CGetWindowTitleDlg::OwnDrawTitleBar()
{
	
}

BOOL CGetWindowTitleDlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	return CDialog::OnEraseBkgnd(pDC);
}


void CGetWindowTitleDlg::OnHide() 
{
	// TODO: Add your control notification handler code here
	int id=(int)hWnd;
	window[count]=id;
	count++;
	::ShowWindow(hWnd,SW_HIDE);

}

void CGetWindowTitleDlg::OnShow() 
{
	// TODO: Add your control notification handler code here
	while(count>0)
	{
		count--;
		int id=window[count];
		HWND h=(HWND)id;
		::ShowWindow(h,SW_SHOW);
	}
}

void CGetWindowTitleDlg::OnChangeTaskBar() 
{
	// TODO: Add your control notification handler code here
	HDC hdc=::GetDC(hWnd);
	CDC dc;
	dc.Attach(hdc);
	dc.TextOut(1,1,"tttttt");
	CBitmap bmp;
	bmp.LoadBitmap(IDB_BITMAP_TASKBAR);
	BITMAP bm;
	bmp.GetObject(sizeof(BITMAP),&bm);
	CDC memDC;
	memDC.CreateCompatibleDC(&dc);
	memDC.SelectObject(&bmp);
	dc.BitBlt(0,0,bm.bmWidth,bm.bmHeight,&memDC,0,0,SRCCOPY);
	


}




void CGetWindowTitleDlg::OnBUTTONParent() 
{
	// TODO: Add your control notification handler code here
	::SetParent(hWnd,GetSafeHwnd());
}
